<?php

namespace App\Bll;

use App\Enums\Session;
use App\Models\Language;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Auth;

class Utility
{

    public static function school_id()
    {
        if (Auth::guard('sanctum')?->user()?->school_id != null) {
            return Auth::guard('sanctum')?->user()?->school_id;
        }
        return null;
    }

    private static function GetLangObject()
    {
        $firstLang = Language::where('code', App::getLocale())->first();
        if ($firstLang == null)
            $firstLang = Language::first();
        if ($firstLang != null) {
            session(Session::SCHOOL_LANG->value, $firstLang);
            return $firstLang;
        }
        $firstLang = Language::create(["code" => App::getLocale(), "title" => App::getLocale()]);
        session(Session::SCHOOL_LANG->value, $firstLang);

        return $firstLang;
    }

    public static function lang_id()
    {

        if (App::getLocale() != Session::getLangCode()) {
            session()->remove(Session::SCHOOL_LANG->value);
            return Utility::GetLangObject()->id;
        }
        if ((session()->input(Session::SCHOOL_LANG->value)))
            return session()->input(Session::SCHOOL_LANG->value)->id;

        return Utility::GetLangObject()->id ?? 1;
    }

    public static function get_dialing_code()
    {
        return +966;
    }

    public function removeZeroFomphone($phone)
    {
        if (substr($phone, 0, 1) == '0') {
            return substr($phone, 1);
        }
        return $phone;
    }


    // get user guard
    public static function getUserGuard()
    {
        return Auth::guard('sanctum')?->user()?->guard;
    }


}
