<?php

namespace App\Modules\Articles\Services;

use App\Bll\Paths;
use App\Modules\Articles\Models\Articles;
use App\Modules\Articles\Resources\ArticlesResource;
use App\Services\Store;
class ArticlesService extends Store
{
    private const Error = "There is no Articles available";
    private const Success = 'All Articles retrieved successfully';
    private const Saved = 'Articles created successfully';

    public function __construct()
    {
        $this->resource = ArticlesResource::class;
        $this->error = self::Error;
        $this->success = self::Success;
        $this->saved = self::Saved;

        parent::__construct(new Articles());
    }

    public function GetAll()
    {
        return $this->Get(
            ['articles.id', 'image', 'title', 'content'],
            ['table' => 'articles_data', 'key' => 'article_id']
        );
    }

    public function storeData()
    {

        $this->public_path = Paths::get_public_path('articles');
        $this->store(
            ['image'],
            ["title", "content"],
            "article_id",
            "image"
        );
        return $this->saved;
    }

    public function updateData(int $id)
    {

        $this->public_path = Paths::get_public_path('articles');
        $this->update(["image"],
            ["title", "content"],
            "article_id",
            $id,
            "image");
        return $this->saved;
    }

    public function edit(int $id)
    {

        if (isset($id) && is_int($id)) {
            $data = Articles::where('id', $id)->first();
            if ($data != null)
                $this->data = ArticlesResource::make($data);
        }
        return 'Articles retrieved successfully';
    }

    public function showData(int $id)
    {
        if (isset($id) && is_int($id)) {
            $data = Articles::where('id', $id)->first();
            if ($data != null) {
                $this->data = ArticlesResource::make($data);
            }
        }
        return 'Article retrieved successfully';
    }

    public function deleteData(int $id)
    {
        $this->delete($id);
        return 'Article deleted successfully';
    }

}
