<?php

namespace App\Modules\Auth\Controllers;

use Illuminate\Http\JsonResponse;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use App\Modules\Auth\Models\Admin;
use App\Modules\Auth\Requests\LoginRequest;
use App\Modules\Auth\Requests\UpdateRequest;
use App\Modules\Auth\Resources\AdminResource;
use App\Modules\Auth\Requests\UpdatePasswordRequest;

class AuthController extends Controller
{

    public function login(LoginRequest $request)
    {
        $admin = Admin::where('email', $request->email)->first();

        if (!$admin) {
            return $this->sendError(__('api.Incorrect Email Or Password'));
        }
        // dd(Hash::make($request->password));
        if (Hash::check($request->password, $admin->password)) {
            // if env local
            if (env('APP_ENV') !== 'local') {
                $admin->tokens()->delete();
            }

            if ($admin->guard == 'admin') {
                $token = $admin->createToken('admin', ['admin'], now()->addMinutes(config('sanctum.expiration')))->plainTextToken;
            } else {
                $token = $admin->createToken('moderator', ['moderator'], now()->addMinutes(config('sanctum.expiration')))->plainTextToken;
            }

            $admin['token'] = $token;

            return $this->sendResponse(AdminResource::make($admin), __('api.login successfully'));
        }
        return $this->sendError(__('api.Email or password'));
    }

    public function logout(): JsonResponse
    {
        if (Auth::check()) {
            Auth::user()?->tokens()->delete();
            return $this->sendResponse([], __('api.Logged out successfully'));
        }
        return $this->sendError(__('api.User not found'));
    }

    public function profile(): JsonResponse
    {
        $user = Auth::user();
        if (!$user) {
            return $this->sendError(__('api.User not found'));
        }
        return $this->sendResponse(AdminResource::make($user), __('api.User data'));
    }

    public function updatePassword(UpdatePasswordRequest $request): JsonResponse
    {
        $user = Auth::guard('sanctum')?->user();
        if (!$user) {
            return $this->sendError(__('api.User not found'));
        }
        if (!Hash::check($request->old_password, $user->password)) {
            return $this->sendError(__('api.Old password is incorrect'));
        }
        $user->password = Hash::make($request->new_password);
        $user->save();
        return $this->sendResponse([], __('api.Password updated successfully'));
    }

    public function updateProfile(UpdateRequest $request)
    {
        $user = Auth::guard('sanctum')?->user();
        if (!$user) {
            return $this->sendError(__('api.User not found'));
        }
        $user->update([
            'name'         => $request->name,
            'email'        => $request->email,
        ]);
        return $this->sendResponse(AdminResource::make($user), __('api.Profile updated successfully'));
    }

}
