<?php

namespace App\Modules\Auth\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class LoginRequest extends FormRequest
{

    public function rules()
    {
        return [
            'email' => [
                'required',
                Rule::exists('users', 'email')->where(function ($query) {
                    $query->whereIn('guard', ['admin', 'moderator']);
                }),
            ],
            'password' => ['required', 'string', 'min:6'],
        ];
    }
}
