<?php

namespace App\Modules\Auth\Requests;

use App\Rules\UniquePhoneUpdate;
use Illuminate\Support\Facades\Auth;
use Illuminate\Foundation\Http\FormRequest;

class UpdateRequest extends FormRequest
{

    public function rules()
    {

        return [
            'name' => 'required|string|max:255|min:3',
            'email' => [
                'required',
                'email',
                'unique:users,email,' . auth()->id()
            ],
        ];
    }
}
