<?php

use App\Modules\Auth\Controllers\AuthController;
use Illuminate\Support\Facades\Route;

Route::prefix('/mcp')->group(function () {
    Route::post('/login', [AuthController::class, 'login']);

    Route::middleware(['auth:sanctum', 'ability:admin,moderator'])->group(function () {
        Route::get('/profile/edit', [AuthController::class, 'profile']);
        Route::put('/profile/update', [AuthController::class, 'updateProfile']);
        Route::post('/profile/password/update', [AuthController::class, 'updatePassword']);
        Route::post('/logout', [AuthController::class, 'logout']);
    });
});
