<?php

namespace App\Modules\Clients\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ClientsResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request)
    {

        return [
            'id' => $this->id,
            'name' => $this->name,
            'job' => $this->job,
            'image' => $this->image ? asset($this->image) : null,
            'img' => $this->image,
            'comment' => $this->comment,
        ];
    }
}
