<?php

namespace App\Modules\Clients\Services;

use App\Bll\Paths;
use App\Bll\Utility;
use App\Services\Store;
use App\Modules\Clients\Models\Clients;
use App\Modules\Clients\Resources\ClientsResource;

class ClientsService extends Store
{
    protected $error;
    protected $success;
    protected $saved;

    public function __construct()
    {
        $this->resource = ClientsResource::class;
        //set messages
        $this->error = __("api.There is no Clients");
        $this->success = __('api.All Clients retrieved successfully');
        $this->saved = __('api.Clients created successfully');

        parent::__construct(Clients::query());
    }

    public function GetAll()
    {
        return $this->Get(["clients.id", "name", "comment", "image", "job"], []);
    }

    public function storeData()
    {
        $this->public_path = Paths::get_public_path('clients');
        $this->store(["name", "comment", "job"], [], "", 'image');
        return $this->saved;
    }

    public function showData(int $id)
    {
        if (isset($id) && is_int($id)) {
            $data = Clients::where('id', $id)->first();
            if ($data != null) {
                $this->data = ClientsResource::make($data);
            }
        }
        return $this->success;
    }

    public function edit(int $id)
    {
        if (isset($id) && is_int($id)) {
            $data = Clients::where('id', $id)->first();
            if ($data != null) {
                $this->data = ClientsResource::make($data);
            }
        }
        return $this->success;
    }

    public function updateData(int $id)
    {
        $this->public_path = Paths::get_public_path('clients');
        $this->update(["name", "comment", "job"], [], "", $id, 'image');
        return $this->saved;
    }

    public function deleteData(int $id)
    {
        $be = Clients::where('id', $id)->first();
        if ($be) {
            $this->delete($id);
        } else {
            return __('api.You can not update this behavior');
        }
    }
}
