<?php

namespace App\Modules\Companies\Services;

use App\Bll\Paths;
use App\Services\Store;
use App\Modules\Companies\Models\Companies;
use App\Modules\Companies\Resources\CompaniesResource;

class CompaniesService extends Store
{
    protected $error;
    protected $success;
    protected $saved;

    public function __construct()
    {
        $this->resource = CompaniesResource::class;
        //set messages
        $this->error = __("api.There is no Companies");
        $this->success = __('api.All Companies retrieved successfully');
        $this->saved = __('api.Companies created successfully');

        parent::__construct(Companies::query());
    }

    public function GetAll()
    {
        return $this->Get(["companies.id", "title", "image", "description"], []);
    }

    public function storeData()
    {
        $this->public_path = Paths::get_public_path('Companies');
        $this->store(["title", "description"], [], "", 'image');
        return $this->saved;
    }

    public function showData(int $id)
    {
        if (isset($id) && is_int($id)) {
            $data = Companies::where('id', $id)->first();
            if ($data != null) {
                $this->data = CompaniesResource::make($data);
            }
        }
        return $this->success;
    }

    public function edit(int $id)
    {
        if (isset($id) && is_int($id)) {
            $data = Companies::where('id', $id)->first();
            if ($data != null) {
                $this->data = CompaniesResource::make($data);
            }
        }
        return $this->success;
    }

    public function updateData(int $id)
    {
        $this->public_path = Paths::get_public_path('Companies');
        $this->update(["title", "description"], [], "", $id, 'image');
        return $this->saved;
    }

    public function deleteData(int $id)
    {
        $be = Companies::where('id', $id)->first();
        if ($be) {
            $this->delete($id);
        } else {
            return __('api.You can not update this Companies');
        }
    }
}
