<?php

namespace App\Modules\CompanyImages\Services;

use App\Bll\Paths;
use App\Services\Store;
use App\Modules\CompanyImages\Models\CompanyImages;
use App\Modules\CompanyImages\Resources\CompanyImagesResource;

class CompanyImagesService extends Store
{
    protected $error;
    protected $success;
    protected $saved;

    public function __construct()
    {
        $this->resource = CompanyImagesResource::class;
        //set messages
        $this->error = __("api.There is no Companies");
        $this->success = __('api.All Companies retrieved successfully');
        $this->saved = __('api.Companies created successfully');

        parent::__construct(CompanyImages::query());
    }

    public function GetAll()
    {
        return $this->Get(["company_images.id", "image"], []);
    }

    public function storeData()
    {
        $this->public_path = Paths::get_public_path('CompanyImages');
        $this->store([], [], "", 'image');
        return $this->saved;
    }

    public function showData(int $id)
    {
        if (isset($id) && is_int($id)) {
            $data = CompanyImages::where('id', $id)->first();
            if ($data != null) {
                $this->data = CompanyImagesResource::make($data);
            }
        }
        return $this->success;
    }

    public function edit(int $id)
    {
        if (isset($id) && is_int($id)) {
            $data = CompanyImages::where('id', $id)->first();
            if ($data != null) {
                $this->data = CompanyImagesResource::make($data);
            }
        }
        return $this->success;
    }

    public function updateData(int $id)
    {
        $this->public_path = Paths::get_public_path('CompanyImages');
        $this->update([], [], "", $id, 'image');
        return $this->saved;
    }

    public function deleteData(int $id)
    {
        $be = CompanyImages::where('id', $id)->first();
        if ($be) {
            $this->delete($id);
        } else {
            return __('api.You can not update this Companies');
        }
    }
}
