<?php

namespace App\Modules\Contact\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ContactResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {

        return [
            'id'         => $this->id,
            'name'       => $this->name,
            'email'      => $this->email,
            'message'    => $this->message,
            'subject'    => $this->subject,
            'phone'      => $this->phone,
            'created_at' => $this->created_at->format('Y-m-d H:i:s'),
        ];
    }
}
