<?php

namespace App\Modules\Contact\Services;

use App\Modules\Contact\Models\Contact;
use App\Modules\Contact\Resources\ContactResource;
use App\Services\Store;

class frontContactService extends Store
{
    private const Error = "There is no Contacts available";
    private const Success = 'All Contacts retrieved successfully';
    private const Saved = 'Contacts created successfully';

    public function __construct()
    {
        $this->resource = ContactResource::class;
        $this->error = self::Error;
        $this->success = self::Success;
        $this->saved = self::Saved;

        parent::__construct(new Contact());
    }

    public function storeData()
    {
        $this->store(["name", "email", "message" , "subject" , "phone"], [], "");
        return $this->saved;
    }
}
