<?php

namespace App\Modules\Founder\Requests;

use App\Rules\ImageInTemp;
use Illuminate\Foundation\Http\FormRequest;

class StoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {

        return [
            'name' => 'required|string',
            'job_title' => 'required|string',
            'qoute' => 'required|string',
            'image' => ['required', new ImageInTemp],
        ];
    }
}
