<?php

namespace App\Modules\Founder\Resources;

use App\Modules\Packages\Resources\PackagesResource;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class FounderEditResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {

        return [
            'id'         => $this->id,
            'name'       => $this->Data ? $this->Data?->first()?->name : null,
            'job_title'  => $this->Data ? $this->Data?->first()?->job_title : null,
            'qoute'      => $this->Data ? $this->Data?->first()?->qoute : null,
            'image'      => $this->image,
            'web_image'  => $this->image ? asset($this->image) : null,
        ];
    }
}
