<?php

namespace App\Modules\Founder\Services;

use App\Bll\Paths;
use App\Services\Store;
use App\Modules\Founder\Models\Founder;
use App\Modules\Founder\Resources\FounderEditResource;

class FounderService extends Store
{
    private const Error = "There is no Founders available";
    private const Success = 'All Founders retrieved successfully';
    private const Saved = 'Founders created successfully';

    public function __construct()
    {
        $this->resource = FounderEditResource::class;
        $this->error = self::Error;
        $this->success = self::Success;
        $this->saved = self::Saved;

        parent::__construct(new Founder());
    }

    public function GetAll()
    {
        return $this->Get(
            ['founder.id', 'name', 'image', 'job_title', 'qoute'],
            ['table' => 'founder_data', 'key' => 'founder_id']

        );
    }

    public function storeData()
    {

        if (Founder::count() > 0) {
            return 'You can not add more than one founder';
        }

        $this->public_path = Paths::get_public_path('founder');
        $this->store(
            ['image'],
            ["name", "job_title", "qoute"],
            "founder_id",
            "image"
        );
        return $this->saved;
    }

    public function edit(int $id)
    {


        if (isset($id) && is_int($id)) {
            $data = Founder::where('id', $id)->first();
            if ($data != null)
                $this->data = FounderEditResource::make($data);
        }
        return 'templates retrieved successfully';
    }

    public function updateData(int $id)
    {

        $this->public_path = Paths::get_public_path('founder');
        $this->update(["image"],
            ["name", "job_title", "qoute"],
            "founder_id",
            $id,
            "image");
        return $this->saved;
    }


    public function showData(int $id)
    {
        if (isset($id) && is_int($id)) {
            $data = Founder::where('id', $id)->first();
            if ($data != null) {
                $this->data = FounderEditResource::make($data);
            }
        }
        return 'Founders retrieved successfully';
    }


}
