<?php

namespace App\Modules\Projects\Models;

use App\Bll\Utility;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;

class Projects extends Model
{
    use SoftDeletes;
    protected $table = 'projects';
    protected $guarded = [];
    public $timestamps = true;

    public function Data(): HasMany
    {
        return $this->hasMany(ProjectsData::class, 'project_id', 'id')->where('lang_id', Utility::lang_id());
    }

    // relation with links
    public function Links(): HasMany
    {
        return $this->hasMany(ProjectsLinks::class, 'project_id', 'id');
    }
    // project cards
    public function Card()
    {
        return $this->hasOne(ProjectsCards::class, 'project_id', 'id');
    }
}
