<?php

namespace App\Modules\Projects\Requests;


use App\Rules\ImageInTemp;
use Illuminate\Foundation\Http\FormRequest;

class UpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {

        return [
            'card_title'                => 'required|string|max:255',
            'card_description'          => 'required|string',
            'card_image'                => ['required', 'string', new ImageInTemp],
            'project_title'             => 'required|string|max:255',
            'project_content'           => 'required|string',
            'project_links'             => 'nullable|array',
            'project_links.*link_type'  => 'nullable|string',
            'project_links.*link'       => 'nullable|string',
        ];
    }
}
