<?php

namespace App\Modules\Projects\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ProjectsCardsResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {

        return [

            'id'            => $this->id,
            'image'         => $this->image? asset($this->image) : null,
            'title'         => $this->Data ? $this->Data->first()->title : null,
            'description'   => $this->Data ? $this->Data->first()->description : null,
        ];
    }
}
