<?php

namespace App\Modules\Projects\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ProjectsResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {

        return [

            'id' => $this->id,
            'project_title' => $this->Data ? $this->Data->first()->title : null,
            'project_content' => $this->Data ? json_decode($this->Data->first()->content) : null,
            'project_thumpnail' => $this?->Card?->image ? asset($this?->Card?->image) : null,
            'local_project_thumpnail' => $this?->Card?->image,
            'project_created_at' => $this->created_at->format('Y-m-d H:i:s'),
            'card' => new ProjectsCardsResource($this->Card),
            'sort' => $this->sort,
            'links' => ProjectsLinksResource::collection($this->Links),


        ];
    }
}
