<?php

use Illuminate\Support\Facades\Route;
use App\Modules\Projects\Controllers\adminController;
use App\Modules\Projects\Controllers\FrontController;

Route::middleware(['auth:sanctum', 'ability:admin,moderator'])->group(function () {
    Route::resource('mcp/projects', adminController::class);
    Route::post('mcp/projects/sort', [adminController::class, 'sortProjects']);
});

Route::get('user/projects/cards', [FrontController::class, "indexCards"]);
Route::get('user/projects', [FrontController::class, "indexProjects"]);
Route::get('user/projects/{id}', [FrontController::class, "showProject"]);
