import React, { ReactNode } from "react";
import { Swiper } from "swiper/react";
import "swiper/css";
import "swiper/css/autoplay";
import "swiper/css/navigation";
import { Autoplay, Navigation } from "swiper/modules";
import SectionTitle from "@/component/mucles/sectionTitle/SectionTitle";

type ProjectsType = {
  children: ReactNode,
  title: string,
  Slides: number,
  phoneSlides: number,
  space?: string
  className?: string
};

const Projects = ({ children, title, Slides, phoneSlides, space, className }: ProjectsType) => {
  return (
    <div  className={`projects rounded-t-3xl flex flex-col items-center relative ${className}`}>
      <div className="flex items-center justify-between w-full px-2 md:px-10">
        <div className="flex items-center mb-10">
          <div className="swiper-button-prev"></div>
          <div className="swiper-button-next"></div>
        </div>
        <SectionTitle color="white">{title}</SectionTitle>
      </div>
      <div className={`w-full mx-auto ${space}`}>
        <Swiper
          modules={[Autoplay, Navigation]}
          spaceBetween={20}
          slidesPerView={Slides} // افتراضي
          loop={true}
          autoplay={{ delay: 3000 }}
          navigation={{
            nextEl: ".swiper-button-next",
            prevEl: ".swiper-button-prev",
          }}
          breakpoints={{
            320: {
              slidesPerView: phoneSlides,
            },
            640: {
              slidesPerView: phoneSlides,
            },
            768: {
              slidesPerView: Slides, 
            },
            1024: {
              slidesPerView: Slides,
            },
          }}
          className="w-full h-3/4 px-16"
        >
          {children}
        </Swiper>
      </div>
    </div>
  );
};

export default Projects;
