import SectionTitle from "@/component/mucles/sectionTitle/SectionTitle";
import { Swiper } from "swiper/react";
import "swiper/css";
import "swiper/css/autoplay";
import "swiper/css/navigation";
import { Autoplay, Navigation } from "swiper/modules";
import { useTranslation } from "react-i18next";

type CustomerReviewsProps = {
    children?: React.ReactNode;
    BgColor: string;
    i18Title: string;
    slidesPerViewMobile?: number; 
    slidesPerViewDesktop: number; 
};

const CustomerReviews = ({ children, BgColor, i18Title, slidesPerViewMobile = 1, slidesPerViewDesktop }: CustomerReviewsProps) => {
    const { t } = useTranslation();

    return (
        <section className="px-5 py-10 mb-20">
            <div className={`rounded-xl bg-[${BgColor}] py-10`}>
                <div className="flex items-center w-full">
                    <div className="flex items-center mb-10">
                        <div className="swiper-button-prev customnerBtn"></div>
                        <div className="swiper-button-next customnerBtn"></div>
                    </div>
                    <SectionTitle color="black">{t(`${i18Title}`)}</SectionTitle>
                </div>
                <div className="container mx-auto px-4">
                    <Swiper
                        modules={[Autoplay, Navigation]}
                        spaceBetween={20}
                        loop={true}
                        autoplay={{ delay: 3000 }}
                        navigation={{
                            nextEl: ".swiper-button-next",
                            prevEl: ".swiper-button-prev",
                        }}
                        className="w-full h-3/4"
                        breakpoints={{
                            0: {
                                slidesPerView: slidesPerViewMobile, // عدد الشرائح للشاشات الصغيرة
                                slidesPerGroup: 1,
                            },
                            640: {
                                slidesPerView: slidesPerViewDesktop, // عدد الشرائح للشاشات الكبيرة
                                slidesPerGroup: 1,
                            },
                        }}
                    >
                        {children}
                    </Swiper>
                </div>
            </div>
        </section>
    );
};

export default CustomerReviews;
