import Image from 'next/image'
import React from 'react'
import { Link } from 'react-scroll'
import logo from '@/public/assets/black-logo.png'

import icon1 from '@/public/assets/1.svg'
import icon2 from '@/public/assets/2.svg'
import icon3 from '@/public/assets/3.svg'
import icon4 from '@/public/assets/4.svg'
import icon5 from '@/public/assets/5.svg'
import icon6 from '@/public/assets/6.svg'

function Footer() {
  return (
    <footer className='bg-[#F5F5F5] mt-10 pt-12'>
      <div className="container mx-auto flex flex-col items-center justify-center w-full p-5">
        <div className='flex flex-col items-center pb-5'>
          <div className='w-full h-full'>
          <Image src={logo} alt="logo" width={100} height={100} />
          </div>
          {/* <div className='p-5 flex justify-center mt-5 space-x-6 text-[10px] lg:text-base font-semibold font-Inter text-[#475467]'>
            <Link to="/" smooth={true} duration={1000} className="cursor-pointer hover:text-blue-600">Overview</Link>
            <Link to="/" smooth={true} duration={1000} className="cursor-pointer hover:text-blue-600">Features</Link>
            <Link to="/" smooth={true} duration={1000} className="cursor-pointer hover:text-blue-600">Pricing</Link>
            <Link to="/" smooth={true} duration={1000} className="cursor-pointer hover:text-blue-600">Careers</Link>
            <Link to="/" smooth={true} duration={1000} className="cursor-pointer hover:text-blue-600">Help</Link>
            <Link to="/" smooth={true} duration={1000} className="cursor-pointer hover:text-blue-600">Privacy</Link>
          </div> */}
        </div>
        <hr className="w-full mt-10 mb-5 border-gray-300" />
        <div className='text-center flex justify-center flex-col lg:flex-row lg:justify-between items-center w-full'>
          <div>
          <p className='font-Inter text-[10px] lg:text-base'>© Soft-Lab. All rights reserved.</p>
          </div>
          <div className="flex space-x-4 py-5">
            <Link to="/" smooth={true} duration={1000}>
              <Image src={icon1} alt="icon1" width={24} height={24} className="cursor-pointer hover:opacity-75" />
            </Link>
            <Link to="/" smooth={true} duration={1000}>
              <Image src={icon2} alt="icon2" width={24} height={24} className="cursor-pointer hover:opacity-75" />
            </Link>
            <Link to="/" smooth={true} duration={1000}>
              <Image src={icon3} alt="icon3" width={24} height={24} className="cursor-pointer hover:opacity-75" />
            </Link>
            <Link to="/" smooth={true} duration={1000}>
              <Image src={icon4} alt="icon4" width={24} height={24} className="cursor-pointer hover:opacity-75" />
            </Link>
            <Link to="/" smooth={true} duration={1000}>
              <Image src={icon5} alt="icon5" width={24} height={24} className="cursor-pointer hover:opacity-75" />
            </Link>
            <Link to="/" smooth={true} duration={1000}>
              <Image src={icon6} alt="icon6" width={24} height={24} className="cursor-pointer hover:opacity-75" />
            </Link>
          </div>
        </div>
      </div>
    </footer>
  )
}

export default Footer
