import { useDisclosure } from "@mantine/hooks";
import { Burger, Drawer } from "@mantine/core";
import NavLanguageAndContact from "../template/Header/NavLanguageAndContact";
import NavLinks from "../template/Header/NavLinks";
import NavLogo from "../template/Header/NavLogo";

function Navbar() {
  const [opened, { toggle }] = useDisclosure(false);

  return (
    <header className="fixed top-0 right-0 z-50 w-screen px-6 py-4 bg-transparent md:px-20">
      <div className="absolute inset-0 bg-[#0C0A2F80] backdrop-blur-lg z-10"></div>

      <nav className="container relative z-20 flex items-center justify-between mx-auto">
        <div className="hidden md:flex">
          <NavLanguageAndContact />
        </div>

        <div className="hidden md:flex">
          <NavLinks />
        </div>

        <div className="flex items-center md:hidden">
          <Burger
            opened={opened}
            onClick={toggle}
            color="white"
            aria-label="Toggle navigation"
          />
        </div>

        <NavLogo />
      </nav>

      <Drawer
        opened={opened}
        onClose={toggle}
        size="50%"
        padding="md"
        position="left"
        withCloseButton
        transitionProps={{
          duration: 0,
        }}
      >
        <NavLinks />
        <NavLanguageAndContact />
      </Drawer>
    </header>
  );
}

export default Navbar;
