import SectionTitle from "@/component/mucles/sectionTitle/SectionTitle"
import { useTranslation } from 'react-i18next';

const AboutUs = () => {
    const { t, i18n } = useTranslation();
    const Language = i18n.language;
    const textDirectionClass = Language === "ar" ? "lg:items-end rtl" : "lg:items-start ltr";
    const titleDirectionClass = Language === "ar" ? "rtl" : "ltr";
    
    return (
        <section className="about-us flex flex-col items-center relative w-full" id="about-us">
            <div className="flex items-center w-full pr-0 lg:pr-6">
                <SectionTitle color="white">{t('AboutUs.title')}</SectionTitle>
            </div>

            <div className="container mx-auto px-4 md:px-10 text-justify">
                <div className={`flex flex-col gap-5 items-center ${textDirectionClass}`} dir={titleDirectionClass}>
                    <p className="text-white font-cairo text-[10px] md:text-[20px] leading-9 font-normal">
                        {t('AboutUs.content')}
                    </p>
                    <p className="text-white font-cairo text-[10px] md:text-[20px] leading-9 font-normal">
                        {t('AboutUs.contentTwo')}
                    </p>
                </div>
            </div>
        </section>
    );
}

export default AboutUs;
