import Image, { StaticImageData } from "next/image";

    type CustomerCardProps = {
    customarImg: string | StaticImageData;
    customarName: string;
    customarTitle: string;
    title: string;
    };

    const CustomerCard = ({ customarImg, customarName, customarTitle, title }: CustomerCardProps) => {
        return (
          <div className="flex flex-col items-start justify-center rounded-lg bg-white p-6 shadow-lg CustomerCardShadow h-52 lg:h-64">
            <svg
              width="29"
              height="30"
              className="lg:h-7 h-4 lg:w-7 w-4"
              viewBox="0 0 29 30"
              fill="none"
              xmlns="http://www.w3.org/2000/svg"
            >
              <path
                opacity="0.9"
                d="M4.11 29.195C2.67 26.825 1.695 24.35 1.185 21.77C0.675 19.19 0.63 16.655 1.05 14.165C1.47 11.675 2.34 9.29 3.66 7.01C5.01 4.7 6.81 2.63 9.06 0.799997L12.525 2.91499C13.125 3.30499 13.395 3.785 13.335 4.355C13.275 4.925 13.08 5.375 12.75 5.705C12.12 6.455 11.52 7.44499 10.95 8.675C10.38 9.905 9.975 11.285 9.735 12.815C9.525 14.345 9.555 15.98 9.825 17.72C10.095 19.46 10.77 21.2 11.85 22.94C12.39 23.81 12.54 24.575 12.3 25.235C12.06 25.865 11.565 26.315 10.815 26.585L4.11 29.195ZM19.05 29.195C17.61 26.825 16.635 24.35 16.125 21.77C15.615 19.19 15.57 16.655 15.99 14.165C16.41 11.675 17.28 9.29 18.6 7.01C19.95 4.7 21.75 2.63 24 0.799997L27.465 2.91499C28.065 3.30499 28.335 3.785 28.275 4.355C28.215 4.925 28.02 5.375 27.69 5.705C27.06 6.455 26.46 7.44499 25.89 8.675C25.32 9.905 24.915 11.285 24.675 12.815C24.465 14.345 24.495 15.98 24.765 17.72C25.035 19.46 25.71 21.2 26.79 22.94C27.33 23.81 27.48 24.575 27.24 25.235C27 25.865 26.505 26.315 25.755 26.585L19.05 29.195Z"
                fill="#1BBBCF"
              />
            </svg>
            <p className="text-[#12141D] text-[12px] lg:text-2xl font-normal mt-2">
              {title}
            </p>
            <div className="flex items-center justify-center mt-5">
              <Image src={customarImg} width={50} height={50} alt="customer Photo" className="h-[35px] w-[35px] lg:w-auto lg:h-auto"/>
              <div className="ml-3">
                <h4 className="lg:text-base text-[10px] font-bold">{customarName}</h4>
                <p className="font-normal lg:text-base text-[9px]">
                 {customarTitle}
                </p>
              </div>
            </div>
          </div>
        );
      };
      

export default CustomerCard;
