import Image from "next/image";
import founder from "/public/assets/eng-mahmoud.png";

const FounderOfSoftLap = () => {
  return (
    <section className="py-10 sm:py-20">
      <div className="container mx-auto bg-[#F5F5F5] rounded-2xl">
        <div className="p-10 sm:p-20">
          <div className="relative bg-founderBG bg-center bg-contain bg-no-repeat w-full min-h-[50vh] sm:min-h-[80vh] flex flex-col items-center justify-center">
            <div className="relative w-[50px] h-[50px] sm:w-[150px] sm:h-[150px] mb-5">
              <Image
                src={founder}
                alt="Founder"
                width={200}
                height={200}
                style={{ objectFit: "cover" }}
              />
            </div>

            <div className="hidden sm:block absolute top-16 sm:top-40 left-20 sm:left-[340px]">
              <svg
                width="70"
                height="250"
                viewBox="0 0 105 366"
                fill="none"
                xmlns="http://www.w3.org/2000/svg"
                className="w-[40] md:w-[80] h-[150] md:h-[280]"
              >
                <path
                  d="M89.8662 101.224L74.9614 161.111H55.2227L74.1558 101.224H89.8662ZM49.0459 101.224L34.5439 161.111H14.4023L33.2012 101.224H49.0459Z"
                  fill="#DFE5E9"
                />
              </svg>
            </div>

            <div className="w-full max-w-xl px-5 mb-5 relative flex justify-center items-center">
              <p className="font-extrabold font-urbanist text-[10px] sm:text-2xl text-white text-center ">
                “Discover the allure of sandy shores, azure waters, and the peaceful rhythm of beach: Beach Bliss”
              </p>
              <div className="absolute -bottom-10 lg:-bottom-28 text-center">
                <h3 className="capitalize text-[#FFFF00] text-[10px] sm:text-xl font-urbanist font-bold">
                  mahmoud raouf
                </h3>
                <p className="capitalize text-[8px] sm:text-sm text-[#FFFFFF99]">
                  founder of soft-lap
                </p>
              </div>
            </div>

          </div>
        </div>
      </div>
    </section>
  );
};

export default FounderOfSoftLap;
