import { useTranslation } from "react-i18next";
import VideoComponent from "@/component/atoms/Video";
import posterSrc from "@/public/assets/IMG_6115.png";

const OurTeam = () => {
  const { t, i18n } = useTranslation();
  const currentLanguage = i18n.language;
  const textDirectionClass = currentLanguage === 'ar' ? 'text-rtl' : 'text-ltr';
  const textStyle = currentLanguage === 'ar' ? 'font-cairo font-medium text-[10px] md:text-[15px]' : 'font-sfpro font-medium text-[10px] md:text-[15px]';


  const title = t("OurTeam.title");
  const description = t("OurTeam.description");
  const supDescription = t("OurTeam.supDescription");
  const data = t("OurTeam.data", { returnObjects: true });

  return (
    <section className={`min-h-[60vh] bg-[#F2F4F7] ${textDirectionClass}`}>
      <div className="container mx-auto px-8 lg:px-16 py-14">
        <div className="flex justify-between gap-5 flex-col lg:flex-row items-center">
          <div>
            <div>
              <h2 className="font-bold text-xl md:text-4xl pb-5 font-Inter">
                {title}
              </h2>
              <p className={`${textStyle}`}>
                {description}
              </p>
            </div>
            <div className="flex w-full gap-10 lg:gap-28 justify-center mt-8 text-center">
              {Object.values(data).map((item: any, index: number) => (
                <div key={index}>
                  <h2 className="text-lg md:text-5xl font-bold font-Inter mb-3">
                    {item.numbers}
                  </h2>
                  <p className={`${textStyle}`}>
                    {item.title}
                  </p>
                </div>
              ))}
            </div>
            <div className="mt-8">
              <p className={`${textStyle}`}
              >
                {supDescription}
              </p>
            </div>
          </div>

          <div className="w-[100%] md:w-[60%]">
            <VideoComponent
              posterSrc={posterSrc}
              videoSrc="/assets/Meet the Team Video Template (Editable).mp4"
            />
          </div>
        </div>
      </div>
    </section>
  );
};

export default OurTeam;
