import SwiperComponent2 from "@/component/mucles/swiperComponent2";
import { SwiperSlide } from "swiper/react";
import Image from "next/image";
import { useTranslation } from "react-i18next";
import { useRouter } from "next/router";

type OtherProjectsProps = {
  projects: any[];
  currentProjectId: number;
};

const OtherProjects = ({ projects, currentProjectId }: OtherProjectsProps) => {
  const { t, i18n } = useTranslation();
  const dir = i18n.language === "ar" ? "rtl" : "ltr";
  const router = useRouter();

  const otherProjects = projects.filter((project: any) => {
    return Number(project.id) !== Number(currentProjectId);
  });

  const handleNavigate = (projectId: number) => {
    router.push(`/project-details/${projectId}`);
  };

  // تكرار الشرائح إذا كانت قليلة للسماح بوضع loop
  const slidesToDisplay = otherProjects.length < 3 ? [...otherProjects, ...otherProjects] : otherProjects;

  return (
    <SwiperComponent2 slidesPerViewDesktop={otherProjects.length < 3 ? otherProjects.length : 3} i18Title="otherProjects.title" BgColor="#F5F5F5">
      {slidesToDisplay.length > 0 ? (
        slidesToDisplay.map((project: any) => (
          <SwiperSlide key={project.id}>
            <div className="mx-auto relative w-[90%] lg:w-full h-[250px] sm:h-[350px] md:h-[422px] cursor-pointer"  onClick={() => handleNavigate(project.id)}>
              <Image
                src={project.card.image || '/default-image.png'}
                alt={`Project Image ${project.id}`}
                fill
                style={{ objectFit: "cover" }}
                className="rounded-lg"
              />
              <div className="absolute inset-0 bg-gradient-to-t from-black to-transparent rounded-lg opacity-0 hover:opacity-100 transition-opacity duration-300">
                <div className="absolute bottom-10 left-0 w-full p-4 text-white text-center">
                  <h3 className="text-lg font-bold">{project.card.title}</h3>
                  <p className="text-sm">{project.card.description}</p>
                </div>
              </div>
            </div>
          </SwiperSlide>
        ))
      ) : (
        <div className="text-center text-black font-medium" dir={dir}>
          {t("ourProjects.noOtherProjects")}...
        </div>
      )}
    </SwiperComponent2>
  );
};

export default OtherProjects;
