import Image from "next/image";
import Walmart from "@/public/assets/Walmart.svg";
import google from "@/public/assets/Google.svg";
import atlassian from "@/public/assets/Atlassian.svg";
import canon from "@/public/assets/Canon.svg";
import amazon from "@/public/assets/Amazon.svg";

const Partners = () => {
  return (
    <div className="container mx-auto flex justify-center px-10 my-10">
      <div className="flex flex-col md:flex-row md:gap-16 justify-center md:justify-between items-center">
        <div className="flex flex-wrap gap-8 lg:gap-16 justify-center md:justify-between">
          <Image src={google} alt="Google Logo" width={95} height={30} className="w-10 h-auto md:w-24" />
          <Image src={atlassian} alt="Atlassian Logo" width={100} height={30} className="w-12 h-auto md:w-28" />
          <Image src={canon} alt="Canon Logo" width={95} height={30} className="w-12 h-auto md:w-28" />
          <Image src={Walmart} alt="Walmart Logo" width={95} height={30} className="w-12 h-auto md:w-28" />
          <Image src={amazon} alt="Amazon Logo" width={95} height={30} className="w-10 h-auto md:w-24" />
        </div>
      </div>
    </div>
  );
};

export default Partners;
