import image from "@/public/assets/image1.png";
import ProjectCard from "./ProjecteCard";
import { useTranslation } from "react-i18next";

type ProjectesProps = {
  data: any;
};

const Projectes = ({ data }: ProjectesProps) => {
  const { t, i18n } = useTranslation();
  const dir = i18n.language === "ar" ? "rtl" : "ltr";

  const projects = data?.result?.data || [];

  return (
    <section className="lg:px-16 px-8">
      {
        projects && projects.length > 0 ? (
          <div className="container mx-auto grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-5">
            {projects.map((project: any) => (
              <ProjectCard
                key={project.id}
                name={project.card.title}
                description={project.card.description}
                image={project.card.image || image}
                id={project.id}
              />
            ))}
          </div>
        ) : (
          <div className="w-full flex justify-center items-center h-60" dir={dir}>
            <p className="text-black font-medium">
              {t("ourProjects.noProjects")}...
            </p>
          </div>
        )
      }
    </section>
  );
};

export default Projectes;
