import Hero from "@/component/template/Hero/Hero";
import OurServices from "@/component/template/OurServices/OurServices";
import OurStatistics from "@/component/template/OurStatistics/OurStatistics";
import ApplicationDevelopment from "@/component/template/OurApplicationDevelopment/ApplicationDevelopment";
import ContactUs from "@/component/template/ContactUs/ContactUs";
import CustomerReviews from "@/component/template/CustomerReviews/CustomerReviews";
import OurProjects from "@/component/template/OurProjects/OurProjects";
import OurPartners from "@/component/template/OurPartners/OurPartners";
import AboutUs from "@/component/template/AboutUs/AboutUs";
import FounderOfSoftLap from "@/component/template/FounderOfSoftLap/FounderOfSoftLap";
import fetchData from "@/FetchData";
import OurTeam from "@/component/template/OurTeam/OurTeam";
import { useEffect } from "react";
import { useRouter } from 'next/router';

type Project = {
  projectsData: {
    result: {
      data: {
        card: {
          title: string;
          description: string;
          image: string;
          id: number;
        };
      }[];
    };
  };
};

const Home = ({ projectsData }: Project) => {
  const router = useRouter();

  useEffect(() => {
    const hash = router.asPath.split('#')[1];
    if (hash) {
      const section = document.getElementById(hash);
      if (section) {
        section.scrollIntoView({ behavior: 'smooth' });
      }
    }
  }, [router.asPath]);

  return (
    <>
      <Hero />
      <OurProjects data={projectsData} />
      <OurServices />
      <OurStatistics />
      <ApplicationDevelopment />
      <AboutUs />
      <ContactUs />
      <CustomerReviews />
      <OurPartners />
      <OurTeam />
      <FounderOfSoftLap />
    </>
  );
};

export default Home;

export async function getServerSideProps(context: any) {
  const { req } = context;
  const keyValuePairs = req?.headers?.cookie?.split(";");
  const languagePair = keyValuePairs?.find((pair: any) =>
    pair.includes("i18next")
  );
  const language = languagePair ? languagePair.split("=")[1] : "ar";

  const projectsData = await fetchData("user/projects", language);

  return {
    props: {
      projectsData: projectsData,
    },
  };
}