import i18n from "i18next";
import { initReactI18next } from "react-i18next";

import translationEN from "@/public/locales/en.json";
import translationAR from "@/public/locales/ar.json";

i18n
  .use(initReactI18next)
  .init({
    resources: {
      en: {
        translation: translationEN,
      },
      ar: {
        translation: translationAR,
      },
    },
    detection: {
      order: ["localStorage", "htmlTag", "cookie", "path"],
      caches: ["localStorage"],
    },
    fallbackLng: "ar",
    interpolation: {
      escapeValue: false,
    },
  });

export default i18n;
